/*
 * Decompiled with CFR 0.152.
 */
package bumpersticker;

import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class BumperSticker
extends JLabel {
    private static final String HEADER = "<html><big>I <font color=";
    private static final String FOOTER = ">&hearts;</font> the Java Tutorial!</big></html>";
    private int mRate = 60;
    private Timer mTimer;
    private int mState = 0;

    public BumperSticker() {
        this.setText("<html><big>I <font color=000000>&hearts;</font> the Java Tutorial!</big></html>");
    }

    public int getRate() {
        return this.mRate;
    }

    public void setRate(int rate) {
        this.mRate = rate;
    }

    public void go() {
        if (this.mTimer != null) {
            return;
        }
        this.mTimer = new Timer();
        long interval = 1935 / this.mRate;
        this.mTimer.scheduleAtFixedRate((TimerTask)new BeatTask(), 0L, interval);
    }

    public static void main(String ... args) {
        JFrame f = new JFrame("BumperSticker");
        f.setDefaultCloseOperation(3);
        f.setBounds(200, 200, 400, 300);
        BumperSticker b = new BumperSticker();
        b.go();
        f.add(b);
        f.setVisible(true);
    }

    private class BeatTask
    extends TimerTask {
        private BeatTask() {
        }

        @Override
        public void run() {
            int scale = BumperSticker.this.mState;
            if (BumperSticker.this.mState > 15) {
                scale = 31 - BumperSticker.this.mState;
            }
            int color = scale << 20 | scale << 16;
            if (++BumperSticker.this.mState >= 31) {
                BumperSticker.this.mState = 0;
            }
            String colorString = String.format("%06x", color);
            BumperSticker.this.setText(BumperSticker.HEADER + colorString + BumperSticker.FOOTER);
        }
    }
}

